<?php
$info = model('App\Models\SchoolInfoModel')->find(1);

$logo = !empty($info['logo_path']) ? base_url($info['logo_path']) : base_url('assets/images/logo1.png');
$schoolName = !empty($info['school_name']) ? esc($info['school_name']) : 'SMAS SENTOSA BHAKTI';
$heroBg = !empty($info['hero_bg_path']) ? "background-image:url('".base_url($info['hero_bg_path'])."');" : '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= $schoolName ?></title>

  <link rel="stylesheet" href="<?= base_url('assets/css/tentang.css') ?>">
  <link rel="stylesheet" href="<?= base_url('assets/fontawesome/css/all.css') ?>">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">
  
  <style>
    :root{
      --hero-bg: url("<?= base_url($info['hero_bg_path'] ?? 'assets/images/fotologo.jpg') ?>");
    }
</style>
<body>

<nav>
  <div class="left-box">
    <img src="<?= $logo ?>" alt="Logo">
    <span class="school-name"><?= $schoolName ?></span>
  </div>

  <ul>
    <a href="<?= base_url() ?>">Beranda</a>
    <a href="<?= base_url('berita') ?>">Berita</a>
    <a href="<?= base_url('galeri') ?>">Galeri</a>
    <a href="<?= base_url('tentang') ?>">Tentang</a>
  </ul>
  
</nav>


<div class="container">

<!-- ===== ABOUT SECTION ===== -->
<?php if (!empty($tentangUtama)): ?>
  <?php foreach ($tentangUtama as $t): ?>
    <div class="about-section">
      <div class="about-image">
        <?php if (!empty($t['foto']) && is_file(FCPATH.'uploads/tentang/'.$t['foto'])): ?>
          <img src="<?= base_url('uploads/tentang/'.$t['foto']) ?>" alt="<?= esc($t['judul']) ?>">
        <?php endif; ?>
      </div>

      <div class="about-content">
        <h2><?= esc($t['judul']) ?></h2>
        <p class="about-text"><?= esc($t['deskripsi']) ?></p>
      </div>
    </div>
  <?php endforeach; ?>
<?php endif; ?>

<!-- ===== NILAI & KARAKTER ===== -->
<?php if (!empty($nilaiItems)): ?>
<div class="values-section">
  <h2>Nilai & Karakter Sekolah</h2>

  <div class="values-grid">
    <?php foreach ($nilaiItems as $v): ?>
      <div class="value-card">
        <div class="value-title"><?= esc($v['judul']) ?></div>
        <div class="value-desc"><?= esc($v['deskripsi']) ?></div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php endif; ?>

<!-- ===== KOMITMEN ===== -->
<?php if (!empty($komitmenItems)): ?>
  <?php foreach ($komitmenItems as $k): ?>
    <div class="commitment-section">
      <h2><?= esc($k['judul']) ?></h2>
      <p><?= esc($k['deskripsi']) ?></p>
    </div>
  <?php endforeach; ?>
<?php endif; ?>

</div>


<script>
// Hamburger Menu Toggle - POSISI DI KANAN
document.addEventListener('DOMContentLoaded', function() {
    // Buat elemen hamburger button
    const hamburger = document.createElement('div');
    hamburger.className = 'hamburger';
    hamburger.innerHTML = '<span></span><span></span><span></span>';
    
    // Tambahkan hamburger ke dalam nav - SETELAH ul (bukan appendChild)
    const nav = document.querySelector('nav');
    const navUl = document.querySelector('nav ul');
    
    // Insert hamburger SETELAH ul, bukan di akhir nav
    nav.insertBefore(hamburger, navUl.nextSibling);
    
    // Get menu ul
    const navMenu = document.querySelector('nav ul');
    
    // Toggle menu saat hamburger diklik
    hamburger.addEventListener('click', function() {
        this.classList.toggle('active');
        navMenu.classList.toggle('active');
    });
    
    // Close menu saat link diklik
    const navLinks = document.querySelectorAll('nav ul a');
    navLinks.forEach(link => {
        link.addEventListener('click', function() {
            hamburger.classList.remove('active');
            navMenu.classList.remove('active');
        });
    });
    
    // Close menu saat klik di luar
    document.addEventListener('click', function(e) {
        if (!nav.contains(e.target)) {
            hamburger.classList.remove('active');
            navMenu.classList.remove('active');
        }
    });
});
</script>
</body>
</html>
